﻿using System;
using System.Linq;
using System.Web.UI;
using Microsoft.SharePoint;

namespace RH.CitiesPerCountryWebpart
{
   public partial class CitiesPerCountryUserControl : UserControl
   {
      SharePointLists _Listen;

      protected void Page_Load(object sender, EventArgs e)
      {
         try
         {
            _Listen = new SharePointLists(SPContext.Current.Web.Url);

            foreach (Land land in _Listen.Laender)
            {
               Controls.Add(new LiteralControl(land.Titel + "<br/>"));
               IQueryable<Stadt> staedte;
               // effizient
               staedte = _Listen.Staedte.Where(s => s.Land.ID == land.ID);
               // nicht effizient
               // staedte = _Listen.Staedte.Where(s => s.Land == land);
               foreach (Stadt stadt in staedte)
               {
                  Controls.Add(new LiteralControl("&nbsp;&nbsp;&nbsp;&nbsp;" + stadt.Titel + "<br/>"));
               }
            }

            // binden der Länderelemente an ein DropDown
            LaenderDDL.DataSource = _Listen.Laender;
            LaenderDDL.DataValueField = "ID";
            LaenderDDL.DataTextField = "Titel";
            LaenderDDL.DataBind();
         }
         catch (Exception ex)
         {
            Controls.Add(new LiteralControl(ex.Message));
         }
      }
   }
}


